/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.command.HMCFormatTable;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.websm.cec.CECInfo;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class HardwareResourcesList
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private static final String ALL_TYPE = HMCCommandUtils.ALL_TYPE;
    private static final String CPU_TYPE = HMCCommandUtils.CPU_TYPE;
    private static final String DRAWER_TYPE = HMCCommandUtils.DRAWER_TYPE;
    private static final String LED_TYPE = HMCCommandUtils.LED_TYPE;
    private static final String MEMORY_TYPE = HMCCommandUtils.MEMORY_TYPE;
    private static final String SLOT_TYPE = HMCCommandUtils.SLOT_TYPE;
    private static final String SMA_TYPE = HMCCommandUtils.SMA_TYPE;
    private static final String ALLOCATED_FORMAT = "allocated";
    private static final String ASSIGNED_TO_FORMAT = "assigned_to";
    private static final String CLASSCODE_FORMAT = "classcode";
    private static final String DRAWER_ID_FORMAT = "drawer_id";
    private static final String FREE_FORMAT = "free";
    private static final String ID_FORMAT = "id";
    private static final String INDEX_FORMAT = "index";
    private static final String KEY_FORMAT = "key";
    private static final String LMB_SIZE_FORMAT = "lmb_size";
    private static final String LOCATION_CODE_FORMAT = "location_code";
    private static final String MAX_FORMAT = "max";
    private static final String MIN_FORMAT = "min";
    private static final String NAME_FORMAT = "name";
    private static final String NETWORK_ID_FORMAT = "network_id";
    private static final String PAGE_TABLE_FORMAT = "page_table";
    private static final String PARTITION_FORMAT = "partition";
    private static final String PARTITION_NAME_FORMAT = "partition_name";
    private static final String PARENT_FORMAT = "parent";
    private static final String PCI_BUS_FORMAT = "pci_bus";
    private static final String PHYSICAL_LOCATION_FORMAT = "phys_loc";
    private static final String REQUESTED_FORMAT = "requested";
    private static final String SLOT_ID_FORMAT = "slot_id";
    private static final String SLOT_TYPE_FORMAT = "slot_type";
    private static final String SNI_DEVICE_ID_FORMAT = "sni_device_id";
    private static final String SNI_WINDOWS_FORMAT = "sni_windows";
    private static final String STATE_FORMAT = "state";
    private static final String STATUS_FORMAT = "status";
    private static final String SYSTEM_FORMAT = "system";
    private String format;
    private String ledType;
    private String managedSystem;
    private String recoveryFlag;
    private String resourceType;
    private String sourcePartition;
    private boolean _allSpecified = false;
    private Vector _lpClientList = null;
    private HSCCECClient hcc;
    private HSCLPARClient hlc;
    private boolean writeStatus;
    private PrintStream output;

    public HardwareResourcesList(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void doAllListOperation() throws HSCException, RequiredParameterException {
        this.doCPUListOperation();
        this.doMemListOperation();
        this.doIOListOperation();
        this.doLEDListOperation();
    }

    private void doCPUListOperation() throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        Vector vector = null;
        if (null == this.sourcePartition) {
            if (this._allSpecified && this._lpClientList != null) {
                Enumeration enumeration = this._lpClientList.elements();
                while (enumeration.hasMoreElements()) {
                    this.hlc = (HSCLPARClient)enumeration.nextElement();
                    Hashtable hashtable2 = this.hlc.getProcessorData();
                    this.printLPARProcessorResults(hashtable2);
                }
            } else {
                vector = this.hcc.getAllProcessorData();
                this.printSystemProcessorResults(vector);
            }
        } else {
            hashtable = this.hlc.getProcessorData();
            this.printLPARProcessorResults(hashtable);
        }
    }

    private void doRecoverableCPUListOperation() throws HSCException {
        Hashtable hashtable = null;
        if (null == this.sourcePartition) {
            hashtable = this.hcc.getRecoverProcessorData();
            this.printRecoverableProcessorResults(hashtable);
        } else {
            hashtable = this.hcc.getRecoverProcessorData();
            this.printRecoverableProcessorResults(hashtable);
        }
    }

    private void doMemListOperation() throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Vector vector = null;
        if (null == this.sourcePartition) {
            if (this._allSpecified && this._lpClientList != null) {
                Enumeration enumeration = this._lpClientList.elements();
                while (enumeration.hasMoreElements()) {
                    this.hlc = (HSCLPARClient)enumeration.nextElement();
                    Hashtable hashtable2 = this.hlc.getMemoryData();
                    this.printLPARMemoryResults(hashtable2);
                }
            } else {
                vector = this.hcc.getAllMemoryData();
                this.printSystemMemoryResults(vector);
            }
        } else {
            hashtable = this.hlc.getMemoryData();
            this.printLPARMemoryResults(hashtable);
        }
    }

    private void doRecoverableMemListOperation() throws HSCException {
        Vector vector = null;
        if (null == this.sourcePartition) {
            vector = this.hcc.getRecoverMemoryData();
            this.printRecoverableMemoryResults(vector);
        } else {
            vector = this.hcc.getRecoverMemoryData();
            this.printRecoverableMemoryResults(vector);
        }
    }

    private void doIOListOperation() throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (null == this.sourcePartition) {
            if (this._allSpecified && this._lpClientList != null) {
                Enumeration enumeration = this._lpClientList.elements();
                while (enumeration.hasMoreElements()) {
                    this.hlc = (HSCLPARClient)enumeration.nextElement();
                    vector2 = this.hlc.getIOSlotData();
                    int n = 0;
                    while (n < vector2.size()) {
                        hashtable = (Hashtable)vector2.get(n);
                        hashtable.put("userName", this.hlc.getUserDefinedName());
                        hashtable.put("intName", this.hlc.getIntName());
                        ++n;
                    }
                    vector.addAll(vector2);
                }
                this.printLPARSlotResults(vector);
            } else {
                vector = this.hcc.getAllIOData();
                this.printSystemSlotResults(vector);
            }
        } else {
            vector = this.hlc.getIOSlotData();
            int n = 0;
            while (n < vector.size()) {
                hashtable = (Hashtable)vector.get(n);
                hashtable.put("userName", this.hlc.getUserDefinedName());
                hashtable.put("intName", this.hlc.getIntName());
                ++n;
            }
            this.printLPARSlotResults(vector);
        }
    }

    private void doRecoverableIOListOperation() throws HSCException {
        Vector vector = null;
        if (null == this.sourcePartition) {
            vector = this.hcc.getRecoverIOData();
            this.printRecoverableSlotResults(vector);
        } else {
            vector = this.hcc.getRecoverIOData();
            this.printRecoverableSlotResults(vector);
        }
    }

    private void doLEDListOperation() throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        String string = null;
        String string2 = null;
        if (!this.resourceType.equals(LED_TYPE) && !this.resourceType.equals(ALL_TYPE) || !this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION) && !this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_IDENTIFY)) {
            string2 = "An invalid parameter was entered for this command. Please try again";
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS", string2, null);
            throw new RequiredParameterException(string);
        }
        if (!this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION) && !this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_IDENTIFY)) {
            string = HSCResourceBundleUtil.getMessage("CECBundle", "LED_TYPE_INVALID");
            throw new HSCException(string);
        }
        hashtable = this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION) ? this.hcc.getSystemAttentionList() : this.hcc.getIdentifyList();
        this.printLEDResults(hashtable);
    }

    private void doSMAListOperation() throws HSCException {
        Vector vector = null;
        vector = this.hcc.getSNIResources();
        this.printSMAResults(vector);
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (this.resourceType != null) {
            if (this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(SLOT_TYPE)) {
                if (this.resourceType == null || this.managedSystem == null) {
                    objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + HMCCommandUtils.RESOURCE_TYPE_PARAM};
                    string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for is command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + " and " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.");
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
            } else if ((this.resourceType.equals(LED_TYPE) || this.resourceType.equals(ALL_TYPE)) && (this.ledType == null || this.managedSystem == null)) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.LED_TYPE_PARAM};
                string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", and " + HMCCommandUtils.LED_TYPE_PARAM + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        } else {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for is command is " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + " and " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        Object var2_2 = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
        if (this._allSpecified) {
            this._lpClientList = this.hcc.getPartitionClients();
        }
        if (null != this.sourcePartition) {
            this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.sourcePartition, false);
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
        }
    }

    private void validateParameters() throws HSCException {
        String string = null;
        if (!(null != this.recoveryFlag || null == this.resourceType || this.resourceType.equals(ALL_TYPE) || this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(SLOT_TYPE) || this.resourceType.equals(LED_TYPE) || this.resourceType.equals(SMA_TYPE))) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_SIMPLE_ERROR_REQUIRED_PARAMETERS");
            throw new HSCException(string);
        }
        if (!(null == this.recoveryFlag || null == this.resourceType || this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(SLOT_TYPE))) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_SIMPLE_ERROR_REQUIRED_PARAMETERS");
            throw new HSCException(string);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.validateParameters();
        this.initializeClients();
        if (this.recoveryFlag != null) {
            if (this.resourceType.equals(CPU_TYPE)) {
                this.doRecoverableCPUListOperation();
            } else if (this.resourceType.equals(MEMORY_TYPE)) {
                this.doRecoverableMemListOperation();
            } else if (this.resourceType.equals(SLOT_TYPE)) {
                this.doRecoverableIOListOperation();
            } else if (this.resourceType.equals(SMA_TYPE)) {
                this.doSMAListOperation();
            }
        } else if (this.resourceType.equals(ALL_TYPE)) {
            this.doAllListOperation();
        } else if (this.resourceType.equals(CPU_TYPE)) {
            this.doCPUListOperation();
        } else if (this.resourceType.equals(MEMORY_TYPE)) {
            this.doMemListOperation();
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            this.doIOListOperation();
        } else if (this.resourceType.equals(LED_TYPE)) {
            this.doLEDListOperation();
        } else if (this.resourceType.equals(SMA_TYPE)) {
            this.doSMAListOperation();
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Object var2_2 = null;
        Object var3_3 = null;
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.format = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM);
        this.recoveryFlag = (String)hashMap.get(HMCCommandUtils.RECOVERY_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        this.sourcePartition = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        String string = (String)hashMap.get(HMCCommandUtils.ALL_PARAM);
        boolean bl = this._allSpecified = string != null;
        if (this._allSpecified && this.sourcePartition != null) {
            MessageFormat messageFormat = new MessageFormat(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_CONFLICT_ARGS", "An error occurred while trying to perform this command. {0} cannot be specified with {1}"));
            String string2 = messageFormat.format(new String[]{"--all", "-p"});
            throw new RequiredParameterException(string2);
        }
        String string3 = (String)hashMap.get(HMCCommandUtils.LED_TYPE_PARAM);
        if (string3 != null) {
            if (string3.equals(HMCCommandUtils.LED_TYPE_SYSTEM_ATTENTION)) {
                this.ledType = HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION;
            } else if (string3.equals(HMCCommandUtils.LED_TYPE_IDENTIFY)) {
                this.ledType = HMCCommandUtils.LED_TYPE_VALUE_IDENTIFY;
            }
        }
    }

    private void printLPARProcessorResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        Short s2 = null;
        Short s3 = null;
        Short s4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (hashtable == null || hashtable.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(8);
                stringArray = new String[]{ALLOCATED_FORMAT, FREE_FORMAT, MAX_FORMAT, MIN_FORMAT, PARTITION_FORMAT, PARTITION_NAME_FORMAT, ASSIGNED_TO_FORMAT, SYSTEM_FORMAT};
                hMCFormatTable.addEntry(stringArray);
            }
            s = (Short)hashtable.get("allocCpus");
            s2 = (Short)hashtable.get("freeCpus");
            s3 = (Short)hashtable.get("maxCpus");
            s4 = (Short)hashtable.get("minCpus");
            string = this.hlc.getUserDefinedName();
            string4 = (String)hashtable.get("userNames");
            string3 = (String)hashtable.get("intNames");
            if (null != this.format) {
                stringTokenizer = new StringTokenizer(this.format, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals(ALLOCATED_FORMAT)) {
                        this.output.print(s);
                    } else if (string2.equals(FREE_FORMAT)) {
                        this.output.print(s2);
                    } else if (string2.equals(MAX_FORMAT)) {
                        this.output.print(s3);
                    } else if (string2.equals(MIN_FORMAT)) {
                        this.output.print(s4);
                    } else if (string2.equals(PARTITION_FORMAT)) {
                        this.output.print(string3);
                    } else if (string2.equals(PARTITION_NAME_FORMAT)) {
                        this.output.print(string4);
                    } else if (string2.equals(ASSIGNED_TO_FORMAT)) {
                        this.output.print(string);
                    } else if (string2.equals(SYSTEM_FORMAT)) {
                        this.output.print(this.managedSystem);
                    } else {
                        this.output.print("");
                    }
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.output.print(":");
                }
                this.output.println();
            } else {
                object = null;
                object = s != null ? s.toString() : "0";
                stringArray[0] = object;
                object = s2 != null ? s2.toString() : "0";
                stringArray[1] = object;
                object = s3 != null ? s3.toString() : "0";
                stringArray[2] = object;
                object = s4 != null ? s4.toString() : "0";
                stringArray[3] = object;
                stringArray[4] = string3;
                stringArray[5] = string4;
                stringArray[6] = string;
                stringArray[7] = this.managedSystem;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n = 0;
                while (n < ((String[])object).length) {
                    this.output.println(object[n]);
                    ++n;
                }
            }
        }
    }

    private void printSystemProcessorResults(Vector vector) {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Short s = null;
        Short s2 = null;
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(4);
                stringArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "STATUS"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ASSIGNED_TO")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                hashtable = (Hashtable)vector.elementAt(n);
                string = (String)hashtable.get("assignedTo");
                string3 = (String)hashtable.get("partitionName");
                s = (Short)hashtable.get("cpuId");
                s2 = (Short)hashtable.get("cpuStatus");
                if (null != this.format) {
                    stringTokenizer = new StringTokenizer(this.format, ":");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals(ID_FORMAT)) {
                            this.output.print(s);
                        } else if (string2.equals(STATUS_FORMAT)) {
                            this.output.print(s2);
                        } else if (string2.equals(PARTITION_FORMAT)) {
                            this.output.print(string3);
                        } else if (string2.equals(ASSIGNED_TO_FORMAT)) {
                            this.output.print(string);
                        } else {
                            this.output.print("");
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        this.output.print(":");
                    }
                    this.output.println();
                } else {
                    object = null;
                    object = s != null ? s.toString() : "";
                    stringArray[0] = object;
                    object = CECInfo.CPU_STATUS_MAP.get(s2.toString()) != null ? (String)CECInfo.CPU_STATUS_MAP.get(s2.toString()) : "";
                    stringArray[1] = object;
                    stringArray[2] = string3;
                    stringArray[3] = string;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    this.output.println(object[n2]);
                    ++n2;
                }
            }
        }
    }

    private void printRecoverableProcessorResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        Short s2 = null;
        Short s3 = null;
        String string = null;
        String string2 = null;
        Object var8_8 = null;
        String string3 = null;
        String string4 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (null == hashtable) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            vector = (Vector)hashtable.get("stoppedCpuIds");
            vector2 = (Vector)hashtable.get("stoppedCpuStates");
            vector3 = (Vector)hashtable.get("stoppedCpuStatus");
            vector4 = (Vector)hashtable.get("stoppedCpuPartitionsInt");
            vector5 = (Vector)hashtable.get("stoppedCpuPartitionsUser");
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(6);
                stringArray = new String[]{ID_FORMAT, STATE_FORMAT, STATUS_FORMAT, PARTITION_FORMAT, PARTITION_NAME_FORMAT, ASSIGNED_TO_FORMAT};
                hMCFormatTable.addEntry(stringArray);
            }
        }
        if (0 == vector.size()) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (this.hlc != null) {
                string = this.hlc.getUserDefinedName();
            }
            int n = 0;
            while (n < vector.size()) {
                s = (Short)vector.elementAt(n);
                s2 = (Short)vector2.elementAt(n);
                s3 = (Short)vector3.elementAt(n);
                string3 = (String)vector4.elementAt(n);
                string4 = (String)vector5.elementAt(n);
                if (null != this.format) {
                    stringTokenizer = new StringTokenizer(this.format, ":");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals(ID_FORMAT)) {
                            this.output.print(s);
                        } else if (string2.equals(STATE_FORMAT)) {
                            this.output.print(s2);
                        } else if (string2.equals(STATUS_FORMAT)) {
                            this.output.print(s3);
                        } else if (string2.equals(PARTITION_FORMAT)) {
                            this.output.print(string3);
                        } else if (string2.equals(PARTITION_NAME_FORMAT)) {
                            this.output.print(string4);
                        } else if (string2.equals(ASSIGNED_TO_FORMAT)) {
                            this.output.print(string);
                        } else {
                            this.output.print("");
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        this.output.print(":");
                    }
                    this.output.println();
                } else {
                    object = null;
                    object = s != null ? s.toString() : "";
                    stringArray[0] = object;
                    object = s2 != null ? s2.toString() : "";
                    stringArray[1] = object;
                    object = s3 != null ? s3.toString() : "";
                    stringArray[2] = object;
                    stringArray[3] = string3;
                    stringArray[4] = string4;
                    stringArray[5] = string;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    this.output.println(object[n2]);
                    ++n2;
                }
            }
        }
    }

    private void printLPARMemoryResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (hashtable == null || hashtable.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(8);
                stringArray = new String[]{ALLOCATED_FORMAT, FREE_FORMAT, LMB_SIZE_FORMAT, MAX_FORMAT, MIN_FORMAT, PARTITION_FORMAT, SYSTEM_FORMAT, PARTITION_NAME_FORMAT};
                hMCFormatTable.addEntry(stringArray);
            }
            n = (Integer)hashtable.get("allocMems");
            n2 = (Integer)hashtable.get("freeMems");
            n3 = (Integer)hashtable.get("LMBSize");
            n4 = (Integer)hashtable.get("maxMems");
            n5 = (Integer)hashtable.get("minMems");
            string3 = (String)hashtable.get("userNames");
            string4 = (String)hashtable.get("intNames");
            string = this.hlc.getUserDefinedName();
            if (null != this.format) {
                stringTokenizer = new StringTokenizer(this.format, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals(ALLOCATED_FORMAT)) {
                        this.output.print(n);
                    } else if (string2.equals(FREE_FORMAT)) {
                        this.output.print(n2);
                    } else if (string2.equals(LMB_SIZE_FORMAT)) {
                        this.output.print(n3);
                    } else if (string2.equals(MAX_FORMAT)) {
                        this.output.print(n4);
                    } else if (string2.equals(MIN_FORMAT)) {
                        this.output.print(n5);
                    } else if (string2.equals(PARTITION_FORMAT)) {
                        this.output.print(string4);
                    } else if (string2.equals(ASSIGNED_TO_FORMAT)) {
                        this.output.print(string);
                    } else if (string2.equals(SYSTEM_FORMAT)) {
                        this.output.print(this.managedSystem);
                    } else if (string2.equals(PARTITION_NAME_FORMAT)) {
                        this.output.print(string3);
                    } else {
                        this.output.print("");
                    }
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.output.print(":");
                }
                this.output.println();
            } else {
                object = null;
                object = n != null ? n.toString() : "0";
                stringArray[0] = object;
                object = n2 != null ? n2.toString() : "0";
                stringArray[1] = object;
                object = n3 != null ? n3.toString() : "";
                stringArray[2] = object;
                object = n4 != null ? n4.toString() : "0";
                stringArray[3] = object;
                object = n5 != null ? n5.toString() : "0";
                stringArray[4] = object;
                stringArray[5] = string4;
                stringArray[6] = this.managedSystem;
                stringArray[7] = string3;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n6 = 0;
                while (n6 < ((String[])object).length) {
                    this.output.println(object[n6]);
                    ++n6;
                }
            }
        }
    }

    private void printSystemMemoryResults(Vector vector) {
        Object object;
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Long l = null;
        Long l2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else if (null == this.format) {
            hMCFormatTable = new HMCFormatTable(4);
            stringArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ALLOCATED"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PAGE_TABLE"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ASSIGNED_TO")};
            hMCFormatTable.addEntry(stringArray);
        }
        int n = 0;
        while (n < vector.size()) {
            hashtable = (Hashtable)vector.elementAt(n);
            string = (String)hashtable.get("assignedTo");
            string3 = (String)hashtable.get("partitionName");
            l = (Long)hashtable.get("allocatedMemory");
            l2 = (Long)hashtable.get("pageTableMemory");
            if (null != this.format) {
                stringTokenizer = new StringTokenizer(this.format, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals(ALLOCATED_FORMAT)) {
                        this.output.print(l);
                    } else if (string2.equals(PAGE_TABLE_FORMAT)) {
                        this.output.print(l2);
                    } else if (string2.equals(PARTITION_FORMAT)) {
                        this.output.print(string3);
                    } else if (string2.equals(ASSIGNED_TO_FORMAT)) {
                        this.output.print(string);
                    } else {
                        this.output.print("");
                    }
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.output.print(":");
                }
                this.output.println();
            } else {
                object = null;
                object = l != null ? l.toString() : "0";
                stringArray[0] = object;
                object = l2 != null ? l2.toString() : "0";
                stringArray[1] = object;
                stringArray[2] = string3;
                stringArray[3] = string;
                hMCFormatTable.addEntry(stringArray);
            }
            ++n;
        }
        if (this.format == null && hMCFormatTable != null) {
            object = hMCFormatTable.getTable();
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                this.output.println(object[n2]);
                ++n2;
            }
        }
    }

    private void printRecoverableMemoryResults(Vector vector) {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(6);
                stringArray = new String[]{ALLOCATED_FORMAT, MAX_FORMAT, MIN_FORMAT, REQUESTED_FORMAT, PARTITION_FORMAT, ASSIGNED_TO_FORMAT};
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.hlc != null) {
                string = this.hlc.getUserDefinedName();
            }
            int n5 = 0;
            while (n5 < vector.size()) {
                Object object;
                hashtable = (Hashtable)vector.elementAt(n5);
                n = (Integer)hashtable.get("allocatedMemory");
                n2 = (Integer)hashtable.get("maxMemory");
                n3 = (Integer)hashtable.get("minMemory");
                n4 = (Integer)hashtable.get("requestedMrmoey");
                string3 = (String)hashtable.get("partitionNameInt");
                string5 = (String)hashtable.get("partitionNameUser");
                string4 = string5 == null ? string3 : string5;
                if (null != this.format) {
                    stringTokenizer = new StringTokenizer(this.format, ":");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals(ALLOCATED_FORMAT)) {
                            this.output.print(n);
                        } else if (string2.equals(MAX_FORMAT)) {
                            this.output.print(n2);
                        } else if (string2.equals(MIN_FORMAT)) {
                            this.output.print(n3);
                        } else if (string2.equals(REQUESTED_FORMAT)) {
                            this.output.print(n4);
                        } else if (string2.equals(PARTITION_FORMAT)) {
                            this.output.print(string4);
                        } else if (string2.equals(ASSIGNED_TO_FORMAT)) {
                            this.output.print(string);
                        } else {
                            this.output.print("");
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        this.output.print(":");
                    }
                    this.output.println();
                } else {
                    object = null;
                    object = n != null ? n.toString() : "0";
                    stringArray[0] = object;
                    object = n2 != null ? n2.toString() : "0";
                    stringArray[1] = object;
                    object = n3 != null ? n3.toString() : "0";
                    stringArray[2] = object;
                    object = n4 != null ? n4.toString() : "0";
                    stringArray[3] = object;
                    stringArray[4] = string4;
                    hMCFormatTable.addEntry(stringArray);
                }
                if (this.format == null && hMCFormatTable != null) {
                    object = hMCFormatTable.getTable();
                    int n6 = 0;
                    while (n6 < ((String[])object).length) {
                        this.output.println(object[n6]);
                        ++n6;
                    }
                }
                ++n5;
            }
        }
    }

    private void printLPARSlotResults(Vector vector) {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        Short s2 = null;
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(8);
                stringArray = new String[]{DRAWER_ID_FORMAT, PCI_BUS_FORMAT, PHYSICAL_LOCATION_FORMAT, SLOT_ID_FORMAT, SLOT_TYPE_FORMAT, SYSTEM_FORMAT, PARTITION_FORMAT, PARTITION_NAME_FORMAT};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                hashtable = (Hashtable)vector.get(n);
                string2 = (String)hashtable.get("IODrawerDeviceID");
                s = (Short)hashtable.get("PCIBus");
                string5 = (String)hashtable.get("SlotLocation");
                s2 = (Short)hashtable.get("SlotID");
                string6 = (String)hashtable.get("ClassCodeInfo");
                string = (String)hashtable.get("userName");
                string4 = (String)hashtable.get("intName");
                if (null != this.format) {
                    stringTokenizer = new StringTokenizer(this.format, ":");
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (string3.equals(ASSIGNED_TO_FORMAT)) {
                            this.output.print(string);
                        } else if (string3.equals(DRAWER_ID_FORMAT)) {
                            this.output.print(string2);
                        } else if (string3.equals(PARTITION_FORMAT)) {
                            this.output.print(string4);
                        } else if (string3.equals(PCI_BUS_FORMAT)) {
                            this.output.print(s);
                        } else if (string3.equals(PHYSICAL_LOCATION_FORMAT)) {
                            this.output.print(string5);
                        } else if (string3.equals(SLOT_ID_FORMAT)) {
                            this.output.print(s2);
                        } else if (string3.equals(SLOT_TYPE_FORMAT)) {
                            this.output.print(string6);
                        } else if (string3.equals(SYSTEM_FORMAT)) {
                            this.output.print(this.managedSystem);
                        } else if (string3.equals(PARTITION_NAME_FORMAT)) {
                            this.output.print(string);
                        } else {
                            this.output.print("");
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        this.output.print(":");
                    }
                    this.output.println();
                } else {
                    object = null;
                    stringArray[0] = string2;
                    object = s != null ? s.toString() : "";
                    stringArray[1] = object;
                    stringArray[2] = string5;
                    object = s2 != null ? s2.toString() : "";
                    stringArray[3] = object;
                    stringArray[4] = string6;
                    stringArray[5] = this.managedSystem;
                    stringArray[6] = string4;
                    stringArray[7] = string;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    this.output.println(object[n2]);
                    ++n2;
                }
            }
        }
    }

    private void printSystemSlotResults(Vector vector) {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (this.format == null) {
                hMCFormatTable = new HMCFormatTable(5);
                stringArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DRAWER_ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SLOT_ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SLOT_TYPE"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ASSIGNED_TO")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                hashtable = (Hashtable)vector.elementAt(n);
                string = (String)hashtable.get("assignedTo");
                string2 = (String)hashtable.get("IODrawerDeviceID");
                string4 = (String)hashtable.get("partitionName");
                string5 = (String)hashtable.get("SlotLocation");
                string6 = (String)hashtable.get("ClassCodeInfo");
                s = (Short)hashtable.get("SlotID");
                if (null != this.format) {
                    stringTokenizer = new StringTokenizer(this.format, ":");
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (string3.equals(DRAWER_ID_FORMAT)) {
                            this.output.print(string2);
                        } else if (string3.equals(SLOT_ID_FORMAT)) {
                            this.output.print(s);
                        } else if (string3.equals(SLOT_TYPE_FORMAT)) {
                            this.output.print(string6);
                        } else if (string3.equals(PHYSICAL_LOCATION_FORMAT)) {
                            this.output.print(string5);
                        } else if (string3.equals(PARTITION_FORMAT)) {
                            this.output.print(string4);
                        } else if (string3.equals(PARTITION_NAME_FORMAT)) {
                            this.output.print(string);
                        } else if (string3.equals(ASSIGNED_TO_FORMAT)) {
                            this.output.print(string);
                        } else {
                            this.output.print("");
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        this.output.print(":");
                    }
                    this.output.println();
                } else {
                    object = null;
                    stringArray[0] = string2;
                    object = s != null ? s.toString() : "";
                    stringArray[1] = object;
                    stringArray[2] = string6;
                    stringArray[3] = string4;
                    stringArray[4] = string;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    this.output.println(object[n2]);
                    ++n2;
                }
            }
        }
    }

    private void printRecoverableSlotResults(Vector vector) {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        Short s2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            Object object;
            if (this.hlc != null) {
                string = this.hlc.getUserDefinedName();
            }
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(6);
                stringArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DRAWER_ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SLOT_ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SLOT_TYPE"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "STATE"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ASSIGNED_TO"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                hashtable = (Hashtable)vector.elementAt(n);
                string2 = (String)hashtable.get("IODrawerDeviceID");
                string3 = (String)hashtable.get("SlotLocation");
                s = (Short)hashtable.get("SlotID");
                string4 = (String)hashtable.get("ClassCodeInfo");
                s2 = (Short)hashtable.get("State");
                string6 = (String)hashtable.get("partitionNameInt");
                string8 = (String)hashtable.get("partitionNameUser");
                string7 = string8 == null ? string6 : string8;
                if (null != this.format) {
                    stringTokenizer = new StringTokenizer(this.format, ":");
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                        if (string5.equals(DRAWER_ID_FORMAT)) {
                            this.output.print(string2);
                        } else if (string5.equals(SLOT_ID_FORMAT)) {
                            this.output.print(s);
                        } else if (string5.equals(SLOT_TYPE_FORMAT)) {
                            this.output.print(string4);
                        } else if (string5.equals(STATE_FORMAT)) {
                            this.output.print(s2);
                        } else if (string5.equals(PARTITION_FORMAT)) {
                            this.output.print(string7);
                        } else if (string5.equals(ASSIGNED_TO_FORMAT)) {
                            this.output.print(string);
                        } else if (string5.equals(PHYSICAL_LOCATION_FORMAT)) {
                            this.output.print(string3);
                        } else {
                            this.output.print("");
                        }
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        this.output.print(":");
                    }
                    this.output.println();
                } else {
                    object = null;
                    stringArray[0] = string2;
                    object = s != null ? s.toString() : "";
                    stringArray[1] = object;
                    stringArray[2] = string4;
                    object = s2 != null ? s2.toString() : "";
                    stringArray[3] = object;
                    stringArray[4] = string;
                    stringArray[5] = string7;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    this.output.println(object[n2]);
                    ++n2;
                }
            }
        }
    }

    private void printLEDResults(Hashtable hashtable) {
        Enumeration enumeration = null;
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        String[] stringArray = null;
        Vector vector = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (hashtable == null || hashtable.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else {
            enumeration = hashtable.keys();
            if (this.format == null) {
                hMCFormatTable = new HMCFormatTable(3);
                stringArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INDEX"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "STATE"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "LOCATION_CODE")};
                hMCFormatTable.addEntry(stringArray);
            }
        }
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            vector = (Vector)hashtable.get(string2);
            String string3 = (String)vector.elementAt(0);
            s = (Short)vector.elementAt(1);
            if (this.format != null) {
                stringTokenizer = new StringTokenizer(this.format, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.equals(INDEX_FORMAT)) {
                        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INDEX") + " = " + string2);
                        continue;
                    }
                    if (string.equals(STATE_FORMAT)) {
                        this.output.print(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "STATE") + " = ");
                        if (s == HMCCommandUtils.LED_SETTING_VALUE_ON) {
                            this.output.println(HMCCommandUtils.LED_SETTING_ON);
                            continue;
                        }
                        this.output.println(HMCCommandUtils.LED_SETTING_OFF);
                        continue;
                    }
                    if (!string.equals(LOCATION_CODE_FORMAT)) continue;
                    this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "LOCATION_CODE") + " = " + string3);
                }
                if (!enumeration.hasMoreElements()) continue;
                this.output.println();
                continue;
            }
            stringArray[0] = string2;
            stringArray[1] = s == HMCCommandUtils.LED_SETTING_VALUE_ON ? HMCCommandUtils.LED_SETTING_ON : HMCCommandUtils.LED_SETTING_OFF;
            stringArray[2] = string3;
            hMCFormatTable.addEntry(stringArray);
        }
        if (this.format == null && hMCFormatTable != null) {
            String[] stringArray2 = hMCFormatTable.getTable();
            int n = 0;
            while (n < stringArray2.length) {
                this.output.println(stringArray2[n]);
                ++n;
            }
        }
    }

    private void printSMAResults(Vector vector) {
        Object object;
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Short s = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
        } else if (this.format == null) {
            hMCFormatTable = new HMCFormatTable(4);
            stringArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SNI_DEVICE_ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PHYSICAL_LOCATION"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NETWORK_ID"), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SNI_WINDOWS")};
            hMCFormatTable.addEntry(stringArray);
        }
        int n = 0;
        while (n < vector.size()) {
            hashtable = (Hashtable)vector.get(n);
            string2 = (String)hashtable.get("NetworkNumber");
            string3 = (String)hashtable.get("PhysicalLocation");
            string4 = (String)hashtable.get("DeviceID");
            s = (Short)hashtable.get("NumOfWindowsSupported");
            if (this.format != null) {
                stringTokenizer = new StringTokenizer(this.format, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.equals(SNI_DEVICE_ID_FORMAT)) {
                        this.output.print(string4);
                    } else if (string.equals(PHYSICAL_LOCATION_FORMAT)) {
                        this.output.print(string3);
                    } else if (string.equals(NETWORK_ID_FORMAT)) {
                        this.output.print(string2);
                    } else if (string.equals(SNI_WINDOWS_FORMAT)) {
                        this.output.print(s.toString());
                    }
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.output.print(":");
                }
                if (n != vector.size()) {
                    this.output.println();
                }
            } else {
                object = new StringBuffer();
                stringArray[0] = string4;
                stringArray[1] = string3;
                stringArray[2] = string2;
                stringArray[3] = s.toString();
                hMCFormatTable.addEntry(stringArray);
            }
            ++n;
        }
        if (this.format == null && hMCFormatTable != null) {
            object = hMCFormatTable.getTable();
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                this.output.println(object[n2]);
                ++n2;
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HARDWARE_RESOURCES_LIST_HELP_R4"));
    }

    public static void main(String[] stringArray) {
        HardwareResourcesList hardwareResourcesList = new HardwareResourcesList(true);
        int n = hardwareResourcesList.process(stringArray);
        System.exit(n);
    }

    public static void entryMethod(String[] stringArray) {
        HardwareResourcesList hardwareResourcesList = new HardwareResourcesList(false);
        hardwareResourcesList.process(stringArray);
    }

    private int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            hSCException.printStackTrace(this.output);
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            requiredParameterException.printStackTrace(this.output);
            string = requiredParameterException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.output);
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }
}

